function [numberOfCuts, cuts, fullDigestFragments,tRFLPreverseFragments,fullDigestFragmentsReverse] = matchSequence(probe_sequence,speciesSequence,newSpecies)
%
%
%

%%%%%%%%%%%%%%%
% match probe string
% find cut sites in sequence string
for i=1:length(newSpecies)
    matchIndex = regexpi(speciesSequence,probe_sequence);
    matchIndex = matchIndex + 1;
    numberOfCuts(i) = length(matchIndex);
    cuts(i,1:numberOfCuts(i)) = matchIndex;
end

%%%%%%%%%%%%%%%
% forward fragments of full digest
for i=1:length(newSpecies)
    if(cuts(i,1) == 0)
        fullDigestFragments(i) = length(speciesSequence);
    else
        fullDigestFragments(i) = cuts(i,1);
    end
end


%%%%%%%%%%%%%%%
% calculate reverse fragments
% for each species: full length of sequence between both primers subtracted
% by each cut site
for i=1:size(cuts,1)
    for j=1:size(cuts,2)
        if(cuts(i,j) == 0)
        else
            tRFLPreverseFragments(i,j) = length(speciesSequence) - cuts(i,j);
        end
    end
end

%%%%%%%%%%%%%%%
% reverse fragments of full digest
for i=1:length(newSpecies)
    if(numberOfCuts(i) == 0)
        fullDigestFragmentsReverse(i) = length(speciesSequence);
    else
        fullDigestFragmentsReverse(i) = tRFLPreverseFragments(i,numberOfCuts(i));
    end
end

end